package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Absorption;
import com.hero.objects.powers.Aid;
import com.hero.objects.powers.Healing;
import com.hero.objects.powers.Succor;
import com.hero.objects.powers.Transform;
import com.hero.util.Rounder;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Cumulative extends Modifier {

	private static String xmlID = "CUMULATIVE";

	public Cumulative(Element root) {
		super(root, Cumulative.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		ret += getAlias();
		double val = getTotalValue();
		for (Adder ad : getAssignedAdders()) {
			if (adderString.length() > 0) {
				adderString += ", ";
			}
			adderString += ad.getAlias() + " (" + getFraction(ad.getBaseCost())
					+ ")";
			val -= ad.getBaseCost();
		}

		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		ret += " (";
		if (getLevels() > 0) {
			ret += getLevelInfo() + "; ";
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += getInput();
			ret += "; ";
		}
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		ret += getFraction(val) + ")";
		if (adderString.trim().length() > 0) {
			if (ret.trim().length() > 0) {
				ret += ", ";
			}
			ret += adderString;
		}
		return ret;
	}

	/**
	 * Displays the max points of effect.
	 */
	@Override
	public String getLevelInfo() {
		int max = getLevels();
		if (getProgenitor() != null) {
			int start = getProgenitor().getLevels() * 6;
			for (Adder adder : getProgenitor().getAssignedAdders()) {
				if (adder.getXMLID().equals("PLUSONEHALFDIE")) {
					start += 3;
				} else if (adder.getXMLID().equals("PLUSONEPIP")) {
					start += 1;
				}
			}
			max = (int) Rounder.roundHalfUp(start * Math.pow(2, max));
		}
		return max + " points";
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if ((o instanceof Absorption) || (o instanceof Aid)
				|| (o instanceof Healing) || (o instanceof Succor)) {
			return o.getDisplay()
					+ " cannot have Cumulative applied to it, since it already has its own rules for how many Character points can be added to a particular Characteristic or Power and how and at what rate they're added.";
		}
		if (o instanceof Transform) {
			return o.getDisplay() + " is already cumulative in nature.";
		}
		if (o.doesDamage()) {
			return getDisplay()
					+ " cannot be applied to abilities that cause STUN or BODY damage.";
		}
		if (o.getDefense().equals("NONE")) {
			return getDisplay()
					+ " can only be applied to abilities which act against a target's Defenses";
		}
		if (o.getTarget().equals("SELFONLY") || o.getTarget().equals("N/A")) {
			return getDisplay()
					+ " can only be applied to abilities which require an Attack Roll.";
		} else {
			return "";
		}
	}

}